/*******************************************************************************

  WangXun(R) 25/10GbE PCI Express Virtual Function Linux Network Driver
  Copyright(c) 2015 - 2017 Beijing WangXun Technology Co., Ltd.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  The full GNU General Public License is included in this distribution in
  the file called "COPYING".

  Contact Information:
  Software Team <linux.nic@trustnetic.com>
  WangXun Technology, HuaXing Times Square A507, Hangzhou, China.

*******************************************************************************/

#ifndef _TXGBE_STATUS_H_
#define _TXGBE_STATUS_H_

/* Error Codes:
 * (-256, 256): reserved for non-txgbe defined error code
 */
#define TXGBE_ERR_BASE (0x100)
enum txgbe_error {
	TXGBE_ERR_NULL = TXGBE_ERR_BASE, /* errline=__LINE__+errno-256 */
	TXGBE_ERR_NOSUPP,
	TXGBE_ERR_EEPROM,
	TXGBE_ERR_EEPROM_CHECKSUM,
	TXGBE_ERR_PHY,
	TXGBE_ERR_CONFIG,
	TXGBE_ERR_PARAM,
	TXGBE_ERR_MAC_TYPE,
	TXGBE_ERR_UNKNOWN_PHY,
	TXGBE_ERR_LINK_SETUP,
	TXGBE_ERR_ADAPTER_STOPPED,
	TXGBE_ERR_INVALID_MAC_ADDR,
	TXGBE_ERR_DEVICE_NOT_SUPPORTED,
	TXGBE_ERR_MASTER_REQUESTS_PENDING,
	TXGBE_ERR_INVALID_LINK_SETTINGS,
	TXGBE_ERR_AUTONEG_NOT_COMPLETE,
	TXGBE_ERR_RESET_FAILED,
	TXGBE_ERR_SWFW_SYNC,
	TXGBE_ERR_PHY_ADDR_INVALID,
	TXGBE_ERR_I2C,
	TXGBE_ERR_SFP_NOT_SUPPORTED,
	TXGBE_ERR_SFP_NOT_PRESENT,
	TXGBE_ERR_SFP_NO_INIT_SEQ_PRESENT,
	TXGBE_ERR_NO_SAN_ADDR_PTR,
	TXGBE_ERR_FDIR_REINIT_FAILED,
	TXGBE_ERR_EEPROM_VERSION,
	TXGBE_ERR_NO_SPACE,
	TXGBE_ERR_OVERTEMP,
	TXGBE_ERR_UNDERTEMP,
	TXGBE_ERR_FC_NOT_NEGOTIATED,
	TXGBE_ERR_FC_NOT_SUPPORTED,
	TXGBE_ERR_SFP_SETUP_NOT_COMPLETE,
	TXGBE_ERR_PBA_SECTION,
	TXGBE_ERR_INVALID_ARGUMENT,
	TXGBE_ERR_HOST_INTERFACE_COMMAND,
	TXGBE_ERR_OUT_OF_MEM,
	TXGBE_ERR_FEATURE_NOT_SUPPORTED,
	TXGBE_ERR_EEPROM_PROTECTED_REGION,
	TXGBE_ERR_FDIR_CMD_INCOMPLETE,
	TXGBE_ERR_FLASH_LOADING_FAILED,
	TXGBE_ERR_XPCS_POWER_UP_FAILED,
	TXGBE_ERR_FW_RESP_INVALID,
	TXGBE_ERR_PHY_INIT_NOT_DONE,
	TXGBE_ERR_TOKEN_RETRY,
	TXGBE_ERR_REG_TMOUT,
	TXGBE_ERR_REG_ACCESS,
	TXGBE_ERR_MBX,
};

#define TXGBE_ERR_NOSUPP                      (-TXGBE_ERR_NOSUPP)
#define TXGBE_ERR_EEPROM                      (-TXGBE_ERR_EEPROM)
#define TXGBE_ERR_EEPROM_CHECKSUM             (-TXGBE_ERR_EEPROM_CHECKSUM)
#define TXGBE_ERR_PHY                         (-TXGBE_ERR_PHY)
#define TXGBE_ERR_CONFIG                      (-TXGBE_ERR_CONFIG)
#define TXGBE_ERR_PARAM                       (-TXGBE_ERR_PARAM)
#define TXGBE_ERR_MAC_TYPE                    (-TXGBE_ERR_MAC_TYPE)
#define TXGBE_ERR_UNKNOWN_PHY                 (-TXGBE_ERR_UNKNOWN_PHY)
#define TXGBE_ERR_LINK_SETUP                  (-TXGBE_ERR_LINK_SETUP)
#define TXGBE_ERR_ADAPTER_STOPPED             (-TXGBE_ERR_ADAPTER_STOPPED)
#define TXGBE_ERR_INVALID_MAC_ADDR            (-TXGBE_ERR_INVALID_MAC_ADDR)
#define TXGBE_ERR_DEVICE_NOT_SUPPORTED        (-TXGBE_ERR_DEVICE_NOT_SUPPORTED)
#define TXGBE_ERR_MASTER_REQUESTS_PENDING     (-TXGBE_ERR_MASTER_REQUESTS_PENDING)
#define TXGBE_ERR_INVALID_LINK_SETTINGS       (-TXGBE_ERR_INVALID_LINK_SETTINGS)
#define TXGBE_ERR_AUTONEG_NOT_COMPLETE        (-TXGBE_ERR_AUTONEG_NOT_COMPLETE)
#define TXGBE_ERR_RESET_FAILED                (-TXGBE_ERR_RESET_FAILED)
#define TXGBE_ERR_SWFW_SYNC                   (-TXGBE_ERR_SWFW_SYNC)
#define TXGBE_ERR_PHY_ADDR_INVALID            (-TXGBE_ERR_PHY_ADDR_INVALID)
#define TXGBE_ERR_I2C                         (-TXGBE_ERR_I2C)
#define TXGBE_ERR_SFP_NOT_SUPPORTED           (-TXGBE_ERR_SFP_NOT_SUPPORTED)
#define TXGBE_ERR_SFP_NOT_PRESENT             (-TXGBE_ERR_SFP_NOT_PRESENT)
#define TXGBE_ERR_SFP_NO_INIT_SEQ_PRESENT     (-TXGBE_ERR_SFP_NO_INIT_SEQ_PRESENT)
#define TXGBE_ERR_NO_SAN_ADDR_PTR             (-TXGBE_ERR_NO_SAN_ADDR_PTR)
#define TXGBE_ERR_FDIR_REINIT_FAILED          (-TXGBE_ERR_FDIR_REINIT_FAILED)
#define TXGBE_ERR_EEPROM_VERSION              (-TXGBE_ERR_EEPROM_VERSION)
#define TXGBE_ERR_NO_SPACE                    (-TXGBE_ERR_NO_SPACE)
#define TXGBE_ERR_OVERTEMP                    (-TXGBE_ERR_OVERTEMP)
#define TXGBE_ERR_UNDERTEMP                   (-TXGBE_ERR_UNDERTEMP)
#define TXGBE_ERR_FC_NOT_NEGOTIATED           (-TXGBE_ERR_FC_NOT_NEGOTIATED)
#define TXGBE_ERR_FC_NOT_SUPPORTED            (-TXGBE_ERR_FC_NOT_SUPPORTED)
#define TXGBE_ERR_SFP_SETUP_NOT_COMPLETE      (-TXGBE_ERR_SFP_SETUP_NOT_COMPLETE)
#define TXGBE_ERR_PBA_SECTION                 (-TXGBE_ERR_PBA_SECTION)
#define TXGBE_ERR_INVALID_ARGUMENT            (-TXGBE_ERR_INVALID_ARGUMENT)
#define TXGBE_ERR_HOST_INTERFACE_COMMAND      (-TXGBE_ERR_HOST_INTERFACE_COMMAND)
#define TXGBE_ERR_OUT_OF_MEM                  (-TXGBE_ERR_OUT_OF_MEM)
#define TXGBE_ERR_FEATURE_NOT_SUPPORTED       (-TXGBE_ERR_FEATURE_NOT_SUPPORTED)
#define TXGBE_ERR_EEPROM_PROTECTED_REGION     (-TXGBE_ERR_EEPROM_PROTECTED_REGION)
#define TXGBE_ERR_FDIR_CMD_INCOMPLETE         (-TXGBE_ERR_FDIR_CMD_INCOMPLETE)
#define TXGBE_ERR_FLASH_LOADING_FAILED        (-TXGBE_ERR_FLASH_LOADING_FAILED)
#define TXGBE_ERR_XPCS_POWER_UP_FAILED        (-TXGBE_ERR_XPCS_POWER_UP_FAILED)
#define TXGBE_ERR_FW_RESP_INVALID             (-TXGBE_ERR_FW_RESP_INVALID)
#define TXGBE_ERR_PHY_INIT_NOT_DONE           (-TXGBE_ERR_PHY_INIT_NOT_DONE)
#define TXGBE_ERR_TOKEN_RETRY                 (-TXGBE_ERR_TOKEN_RETRY)
#define TXGBE_ERR_REG_TMOUT                   (-TXGBE_ERR_REG_TMOUT)
#define TXGBE_ERR_REG_ACCESS                  (-TXGBE_ERR_REG_ACCESS)
#define TXGBE_ERR_MBX                         (-TXGBE_ERR_MBX)

#endif /* _TXGBE_STATUS_H_ */
